<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use kartik\select2\Select2;
use yii\web\JsExpression;
use common\models\Customers;
use common\models\Staffs;
/* @var $this yii\web\View */
/* @var $model common\models\Services */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="services-form">

    <?php $form = ActiveForm::begin(); ?>
    <div class="box clearfix">
        <div class="box-body table-responsive">
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                            echo $form->field($model, 'user_id')->widget(Select2::classname(), [
                                'data' => Customers::getAllCustomers(),
                                'options' => ['placeholder' => 'Select A Customer'],
                                'pluginOptions' => [
                                    'allowClear' => true
                                ]
                            ]);
                           


                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                    <?= $form->field($model, 'service_note')->textarea(['rows' => 6]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                    <?= $form->field($model, 'call_type')->dropDownList([ 'inbound' => 'In Bound', 'outbound' => 'Out Bound'], ['prompt' => 'Select call Type']) ?>
                    </div>

                    <div class="col-md-6">
                    <?php 
                    $servicetypes = ['Service' => 'Service', 'Customisation' => 'Customisation', 'Renewal' => 'Renewal','New Purchase' => 'New Purchase'];
                    ?>
                    <?= $form->field($model, 'service_type')->dropDownList($servicetypes, [ 'prompt' => 'Select service type']) ?>
                    </div>  

                           
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'completion_date')->widget(DatePicker::classname(), ['options' => ['placeholder' => 'Enter order date ...', 'autocomplete' => 'off'], 'pluginOptions' => ['format' => 'yyyy-mm-dd', 'todayHighlight' => true, 'autoclose' => true,]]) ?>
                    </div>
                    <div class="col-md-6">
                        <?php 
                        $servicemode = ['Paid' => 'Paid Service', 'Free' => 'Free Service'];
                        // $disabled['Paid', ] =  ['disabled' => true];
                        $selected['Paid'] = ['Selected'=>'selected'];
                        $disabled = false ;        
                        ?>
                        <?= $form->field($model, 'service_mode')->dropDownList($servicemode, ['options'=> $selected, 'disabled' => $disabled, 'prompt' => 'Select service mode']) ?>
                    </div> 
                </div>

                <div class="row">
                <div class="col-md-6">
                        <?= $form->field($model, 'total_amount')->textInput() ?>
                    </div>
                    
                    <?php
                    if($model->isNewRecord){
                        ?>
                        <div class="col-md-6">
                        <?= $form->field($model, 'amount_paid')->textInput() ?>
                    </div>
                    <?php
                    }
                    ?>
                    <?php
                    if(!$model->isNewRecord){
                        ?>
                    <div class="col-md-6">
                    <?= $form->field($model, 'status')->dropDownList([ 'Pending' => 'Pending', 'On Progress' => 'On Progress', 'Completed' => 'Completed', 'Cancelled' => 'Cancelled', ], ['prompt' => 'Select A Status']) ?>
                    </div>
                    <?php
                    }
                    ?>    
                </div>
                            
                
                <div class="form-group">
                    <?= Html::submitButton($model->isNewRecord ? 'Create Service' : 'Update Service', ['class' => 'btn btn-success']) ?>
                </div>
            </div>
        </div>
    </div>
    <?php ActiveForm::end(); ?>

</div>
<?php
$this->registerJs(
        " $(document).ready(function () {
        $('#orders-form').on('beforeSubmit', function (e) {
            $('.btn').addClass('disabled');
        });
    });"
);
?>